uniform float u_time;
uniform float u_aspectRatio;
uniform vec2 u_resolution;

uniform sampler2D s_texture;

varying vec2 v_texCoord;

// http://www.fractalforums.com/new-theories-and-research/very-simple-formula-for-fractal-patterns/
float field(in vec3 p) 
{
	float strength = 7. + .03 * log(1.e-6 + fract(sin(u_time) * 4373.11));
	float accum = 0.;
	float prev = 0.;
	float tw = 0.;
	for (int i = 0; i < 32; ++i) 
	{
		float mag = dot(p, p);
		p = abs(p) / mag + vec3(-.21, -.4, -1.3);
		float w = exp(-float(i) / 7.);
		accum += w * exp(-strength * pow(abs(mag - prev), 2.3));
		tw += w;
		prev = mag;
	}
	
	return max(0.1, 5. * accum / tw - .4);
}

vec3 nrand3(vec2 co)
{
	vec3 a = fract(cos(co.x*8.3e-3 + co.y)*vec3(1.3e5, 4.7e5, 2.9e5));
	vec3 b = fract(sin(co.x*0.3e-3 + co.y)*vec3(8.1e5, 1.0e5, 0.1e5));
	vec3 c = mix(a, b, 10.5);	
	return c;
}

void main() 
{
	vec2 res = u_resolution;
	res = res * u_time / 25.0;

	vec2 uv = 1.0 * gl_FragCoord.xy / res.xy - 1.0;
	vec2 uvs = uv * res.xy / max(res.x, res.y);
	
	vec3 p = vec3(uvs / 4., 0) + vec3(2., -1.3, -1.);
	p += .15 * vec3(sin(u_time / 16.), sin(u_time / 12.),  sin(u_time / 128.));
	
	vec3 p2 = vec3(uvs / (4.+sin(u_time*0.11)*0.2+0.2+sin(u_time*0.15)*0.3+0.4), 1.5) + vec3(2., -1.3, -1.);
	p2 += 0.15 * vec3(sin(u_time / 16.), sin(u_time / 12.),  sin(u_time / 128.));
	
	float t = field(p);
	float t2 = field(p2);
	float v = (1. - exp((abs(uv.x) - 10.) / 6.)) * (1. - exp((abs(uv.y) - 1.) * 6.));
	
	vec4 c1 = mix(.4, 1., v) * vec4(1.8 * t * t * t, 1.4 * t * t, t, 1.0);
	vec4 c2 = mix(.4, 1., v) * vec4(1.4 * t2 * t2 * t2, 1.* t2 * t2, t2, 1.0);
	c1.b *= mod(gl_FragCoord.y+1.0, 2.0)*1.4;
	c2.r *= mod(gl_FragCoord.y, 2.0)*7.4;
	c2.r *= 9.0;
	
	vec4 vblend = c1 + c2;
	float intensity = dot(vblend.rgb, vec3(0.299, 0.587, 0.114));
	
	gl_FragColor = vec4(vblend.r, vblend.g, vblend.b, smoothstep(0.2,0.8,intensity));
}
